
from flask import Flask, render_template, request
import requests

app = Flask(__name__)
API_URL = "http://localhost:8000/v1/completions"

@app.route("/", methods=["GET", "POST"])
def index():
    response_text = ""
    if request.method == "POST":
        prompt = request.form["prompt"]
        data = {
            "prompt": prompt,
            "max_tokens": 500,
            "temperature": 0.7
        }
        try:
            res = requests.post(API_URL, json=data)
            response_text = res.json()["choices"][0]["text"]
        except Exception as e:
            response_text = f"Fehler: {e}"
    return render_template("index.html", response=response_text)

if __name__ == "__main__":
    app.run(host="0.0.0.0", port=5000)
